/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

#ifndef __DRMBLACKBOX_SEP_H__
#define __DRMBLACKBOX_SEP_H__


#ifdef __cplusplus
extern "C" {
#endif

	DRM_RESULT DRM_API DRM_BBX_HashValue_SEP(
		IN        DRM_BYTE *pbTableAdd,   /*MLLI first table base address*/
		IN        DRM_DWORD cbTableSize,  /*MLLI first table size */
		IN        DRM_DWORD dataInSize,   /*MLLI first table data size*/
		IN        DRM_BYTE *pbHeadDataAdd,   /*Tail data(used for hash end of data treatment */
		IN        DRM_DWORD cbHeadDataSize,  /*size of the tail data*/
		IN        DRM_BYTE *pbTailDataAdd,   /*Tail data(used for hash end of data treatment */
		IN        DRM_DWORD cbTailDataSize,  /*size of the tail data*/
		OUT       DRM_BYTE        rgbHashValue [__CB_DECL(SHA_DIGEST_LEN)],
		IN        DRM_BB_CONTEXT *pcontextBBX );
    
DRM_BOOL DRM_API DRM_BBX_DecryptLicense_SEP(
	IN     DRM_BYTE       pbEncryptedLicenseKey[__CB_DECL(PK_ENC_CIPHERTEXT_LEN)],
	IN     DRM_BYTE       *pbEncryptedLicenseTable,    /* MLLI first in table base address */
	IN     DRM_DWORD      cbEncryptedLicenseTableSize, /* MLLI first in table size */
	IN     DRM_BYTE       *pbDecryptedLicenseTable,    /*MLLI first out table base address */ 
	IN     DRM_DWORD      cbDecryptedLicenseTableSize, /* MLLI first out table size */
	IN     DRM_DWORD      cbLicenseSize,				/*MLLI first table data size */
	IN     DRM_BB_CONTEXT *pcontextBBX );


/******************************************************************************
** Function :   DRM_BBX_SignData
** Synopsis :   Sign data with the machine private key 
** Arguments :  f_pcontextBBX       - Blackbox context
**              f_pbData            - Data to be signed
**              f_cbData            - Size of data to be signed
**              f_rgbSignature      - Signature
******************************************************************************/
DRM_RESULT DRM_API DRM_BBX_SignData_SEP(
										IN       DRM_BB_CONTEXT *f_pcontextBBX,
										IN       DRM_BYTE *pbTableAdd,   /*MLLI first table base address*/
										IN       DRM_DWORD cbTableSize,  /*MLLI first table size */
										IN       DRM_DWORD dataInSize,   /*MLLI first table data size*/
										IN       DRM_BYTE *pbTailDataAdd,   /*Tail data used for the end of the hash*/
										IN       DRM_DWORD cbTailDataSize,  /*size of the tail data */
										IN       DRM_DWORD       f_ePrivKeyType,
										OUT   DRM_BYTE        f_rgbSignature[__CB_DECL(PK_ENC_SIGNATURE_LEN)]);


/*********************************************************************
**
**  Function:  DRM_BBX_SymmetricSign
**
**  Synopsis:  Creates a symmetric signature (that only the current blackbox can verify) over the data provided 
**             by the caller
**
**  Arguments:  
**     [f_pcontextBBX] -- Pointer to an initialized blackbox context
**     [f_pbData]      -- Pointer to the data to sign
**     [f_cbData]      -- Length of f_pbData in DRM_BYTEs
**     [f_rgbSymSig]   -- Buffer to place the resultant 'symmetric signature'
**
*********************************************************************/

DRM_RESULT DRM_API DRM_BBX_SymmetricSign_SEP(
	IN       DRM_BB_CONTEXT *f_pcontextBBX,
	IN		 DRM_BYTE       *f_pbDataTable, /*MLLI first table base address */
	IN       DRM_DWORD       f_cbDataTable, /*MLLI first table size */
	IN       DRM_DWORD       f_cbData, /*MLLI first table data size */
	IN		 DRM_BYTE       *f_pbTailData, /*Tail data used for the end of the hash */
	IN       DRM_DWORD       f_cbTailData, /*size of the tail data */
	OUT      DRM_BYTE        f_rgbSymSig[__CB_DECL( SHA_DIGEST_LEN )] );




/*********************************************************************
**
**  Function:  DRM_BBX_SymmetricVerify
**
**  Synopsis:  Verifies a symmetric signtaure that was created by a call to DRM_BBX_SymmetricSign
**
**  Arguments:  
**     [f_pcontextBBX] -- Pointer to an initialized blackbox context
**     [f_pbData]      -- Pointer to the data to sign
**     [f_cbData]      -- Length of f_pbData in DRM_BYTEs
**     [f_pslk]        -- Optional.  If this parameter is provided the caller is asking to verify
**                        the signature with a BBX protected SLK key.
**     [f_rgbSymSig]   -- Buffer containing the signtature to compare against.
**
*********************************************************************/

DRM_RESULT DRM_API DRM_BBX_SymmetricVerify_SEP(
	IN       DRM_BB_CONTEXT *f_pcontextBBX,
	IN		 DRM_BYTE       *f_pbDataTable, /*MLLI first table base address */
	IN       DRM_DWORD       f_cbDataTable, /*MLLI first table size */
	IN       DRM_DWORD       f_cbData,      /*MLLI first table data size */
	IN		 DRM_BYTE       *f_pbTailData, /*Tail data used for the end of the hash */
	IN       DRM_DWORD       f_cbTailData, /*size of the tail data */
	IN const DRM_SLK        *f_pslk,
	IN const DRM_BYTE        f_rgbSymSig[__CB_DECL( SHA_DIGEST_LEN )] );


#ifdef __cplusplus
}
#endif

#endif /* __DRMBLACKBOX_H__ */
